<?php 
    /**
    *
    * copyright (c) 2013-2023 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/index.php?alias=linee-guida-per-luso-del-logo-geecom
    */

    include "../include/includeBaseComponenti.php";
    include "../../../template/stile.php";
    
    if(isset($_GET["id"])) {
        $elemento = $geecomDb->leggiSingolaRiga("geec_testimonianze",filter_input(INPUT_GET,"id",FILTER_SANITIZE_NUMBER_INT));
        $datiOccorrenza = $geecomDb->leggiSingolaRiga("geec_visualizzatoriTestimonianze",$elemento["idVisualizzatoreTestimonianze"]);
    }
?>
<!doctype html>
<html lang="en">
    <head>
        <!-- Required meta tags -->
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">

        <?php
            include "../include/cssBaseComponenti.php";
        ?>
        <title>Geecom CMS - Creazione testimonianza</title>
    </head>
    <body>
    
        <header>
            <?php 
                include "../../include/barraSuperiore.php";

                include "../../include/header.php";

                include "../../include/barraMenu.php";
            ?>
        </header>
	
        <main role="main" class="bg-light" id="main">
            <div class="container-fluid">

                <?php 
                    if(isset($_GET["status"])) {
                        $status = filter_input(INPUT_GET,"status",FILTER_SANITIZE_NUMBER_INT);
                    }
                    else {
                        $status = 0;
                    }

                ?>

                <div class="row py-4">
                    <?php 
                        if($status==200) {
                            echo"<div class=\"col-12\">
                                    <div class=\"alert alert-success alert-dismissible fade show\" role=\"alert\">
                                        Testimonianza modificata
                                        <button type=\"button\" class=\"close\" data-dismiss=\"alert\" aria-label=\"Close\">
                                            <span aria-hidden=\"true\">&times;</span>
                                        </button>
                                    </div>
                                </div>";
                        }
                        else if($status==220) {
                            echo"<div class=\"col-12\">
                                    <div class=\"alert alert-success alert-dismissible fade show\" role=\"alert\">
                                        Testimonianza duplicata, modificala per non avere due testimonianze uguali
                                        <button type=\"button\" class=\"close\" data-dismiss=\"alert\" aria-label=\"Close\">
                                            <span aria-hidden=\"true\">&times;</span>
                                        </button>
                                    </div>
                                </div>";
                        }
                    ?>
                    <div class="col-12">
                        <div class="form-row justify-content-between mb-3">
                            <div class="col-auto d-flex">
                                <nav aria-label="breadcrumb" class="align-self-center">
                                    <ol class="breadcrumb p-0 mb-1 mb-md-0 bg-transparent">
                                        <li class="breadcrumb-item"><a href="../../home.php">Home</a></li>
                                        <li class="breadcrumb-item"><a href="#" data-toggle="modal" data-target="#menu-componenti">Componenti</a></li>
                                        <li class="breadcrumb-item"><a href="index.php">Testimonianze</a></li>
                                        <li class="breadcrumb-item"><a href="creaTestimonianze.php?id=<?php echo $datiOccorrenza["id"] ?>"><?php echo $datiOccorrenza["nome"] ?></a></li>
                                        <li class="breadcrumb-item active" aria-current="page"><?php echo((isset($elemento)? $elemento["nome"] : "Nuova testimonianza"))?></li>
                                    </ol>
                                </nav>
                            </div>
                            <div class="col-auto text-right">
                                <a class="btn btn-outline-primary" href="creaTestimonianze.php?id=<?php echo $datiOccorrenza["id"] ?>"><i class="fas fa-arrow-left mr-2"></i>Torna all'elenco</a>
                                <button class="btn btn-primary" onclick="document.formComponente.submit()"><i class="fas fa-check"></i> Salva</button>
                                <?php 
                                    if(isset($elemento)) {
                                ?>
                                        <button type="button" class="btn btn-warning mt-2 mt-lg-0" onclick="location.href='controller/controllerComponente.php?id=<?php echo $elemento["idVisualizzatoreTestimonianze"] ?>&operazione=duplicaElemento&idElemento=<?php echo $elemento["id"] ?>';"><i class="far fa-clone mr-2"></i>Duplica</button>
                                <?php
                                    }
                                ?>
                            </div>
                        </div>
                        
                        <form name="formComponente" action="controller/controllerComponente.php" method="post">
                            <input type="text" class="d-none" name="operazione" value="<?php echo((isset($elemento) ? "modificaElemento" : "crea")); ?>">
                            <input type="text" class="d-none" name="idElemento" value="<?php echo((isset($elemento) ? $elemento["id"] : "0")); ?>">

                            <div class="card mb-4 box-shadow-lite">
                                <div class="card-body">
                                    <div class="row">
                                        <div class="col-lg-7 ">
                                            <div class="row">
                                                <div class="form-group col-12">
                                                    <h6 class="mt-2 mr-2 text-nowrap">Nome</h6>
                                                    <input  type="text" class="form-control" name="nome" value="<?php echo((isset($elemento)? $elemento["nome"] : ""))?>" placeholder="Nome elemento">
                                                    <small class="text-muted">Questo campo serve solo per identificare la testimonianza e non verrà mostrato sul sito</small>
                                                </div>
                                                
                                                <div class="form-group col-md-6">
                                                    <label>Autore</label>
                                                    <input  type="text" class="form-control" name="autore" value="<?php echo((isset($elemento)? $elemento["autore"] : ""))?>" placeholder="Ruolo">
                                                </div>
                                                
                                                <div class="form-group col-md-6">
                                                    <label for="titolo-articolo">Ruolo</label>
                                                    <input  type="text" class="form-control" name="ruolo" value="<?php echo((isset($elemento)? $elemento["ruolo"] : ""))?>" placeholder="Ruolo">
                                                </div>

                                                <div class="form-group col-md-6">
                                                    <label for="titolo-articolo">Azienda</label>
                                                    <input  type="text" class="form-control" name="azienda" value="<?php echo((isset($elemento)? $elemento["azienda"] : ""))?>" placeholder="Azienda">
                                                </div>
                                                
                                                <div class="form-group col-md-6">
                                                    <label for="titolo-articolo">Email</label>
                                                    <input  type="text" class="form-control" name="email" value="<?php echo((isset($elemento)? $elemento["email"] : ""))?>" placeholder="Email">
                                                </div>

                                                <div class="form-group col-md-6">
                                                    <label for="titolo-articolo">Stelle</label>
                                                    <select class="form-control" name="stelle">
                                                        <option value="0">Non mostrare</option>
                                                        <?php 
                                                            for($i=1; $i<6; $i++) {
                                                                if(isset($elemento) && $i==$elemento["stelle"]) {
                                                                    echo"<option value=\"$i\" SELECTED>{$i}</option>";						
                                                                }
                                                                else {
                                                                    echo"<option value=\"$i\">{$i}</option>";
                                                                }
                                                            }
                                                        ?>
                                                    </select>
                                                </div>
                                            </div>

                                            <div class="form-group col-md-4">
                                                <label class="d-block">Consenso pubblicazione</label>
                                                <input type="checkbox" name="consensoPubblicazione" class="js-switch" <?php echo((isset($elemento) && $elemento["consensoPubblicazione"]=="si") ? "checked" : "1") ?> value="si">
                                            </div>

                                            <div class="my-4">
                                                <textarea class="tiny" name="descrizione"><?php echo(isset($elemento) ? $elemento["testo"] : "") ?></textarea>
                                            </div>
                                        </div>
                                    </form>

                                        <div class="col-lg-5">
                                            <div class="card mb-3 rounded-0 accordion box-shadow-lite">
                                                <div class="card-header collapsed" data-toggle="collapse" href="#ImmagineInEvidenza">
                                                    <a class="card-title">
                                                        Immagine
                                                    </a>
                                                </div>
                                                <div id="ImmagineInEvidenza" class="collapse show">
                                                    <div class="card-body">
                                                        <div class="img-container">
                                                            <div class="azioni">
                                                                <div class="btn-group" role="group" aria-label="">
                                                                    <button onclick="eliminaImmagineInEvidenza()" type="button" class="btn btn-sm btn-light elimina" data-toggle="tooltip" data-placement="bottom" title="Rimuovi"><i class="far fa-trash-alt"></i></button>
                                                                </div>
                                                            </div>

                                                            <img id="immagineElemento" class="img-fluid w-100 mb-3" src="../../../<?php echo((isset($elemento) && $elemento["immagine"]!="") ? $elemento["immagine"] : "immagini/altro/segnaposto.png") ?>" alt="immagine attuale">
                                                        </div>

                                                        <button type="button" class="btn btn-outline-primary btn-block mb-3" onclick="apriPopupSelezioneImmagini()"><i class="far fa-image"></i> Scegli da immagini caricate</button>

                                                        <form action="controller/controllerComponente.php" id="frmFileUpload-00" class="dropzone singolo-file" method="post" enctype="multipart/form-data">
                                                            <div class="dz-message">
                                                                <i class="fas fa-file-upload fa-2x mb-2"></i>
                                                                <h5>Trascina o carica qui l'immagine</h5>
                                                            </div>
                                                            <div class="fallback">
                                                                <input name="file" type="file" />
                                                            </div>
                                                        </form>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                
                                    
                                    <button type="button" class="btn btn-primary float-right mt-3" onclick="document.formComponente.submit()"><i class="fas fa-check"></i> Salva</button>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </main>

        <?php 
            include "../../include/footer.php";

            include "../include/modal/cambiaPassword.php";

            include "../../include/modal/modalMenuComponenti.php";

            include "../../include/modal/operazioneCompletata.php";

            include "../../include/modal/modalSelezionaFoto.php";
                        
            include "../include/jsBaseComponenti.php";
        ?>
        
        <!-- Dropzone -->
        <script type="text/javascript" src="../../../plugins/dropzone/dropzone.js"></script>
        <script>
            $("#frmFileUpload-00").dropzone({
                acceptedFiles: ".jpeg,.jpg,.png,.webp,.gif,.svg",
                maxFiles: 1,
                addRemoveLinks: true,
                dictRemoveFile: "Rimuovi",
                success: function(file,response) {
                    document.getElementById("immagineElemento").src=response;
                    this.removeAllFiles();
                },
                params:{
                    operazione:"modificaImmagineElemento",
                    idElemento:<?php echo $elemento["id"] ?>
                },
                maxfilesexceeded: function(file) {
                    this.removeAllFiles();
                    this.addFile(file);
                }
            })
        </script>

        <script>
            function modificaImpostazioniSezione(id,idSezione,classeSezione,aTuttaLarghezza,margineSezione,paddindSezione) {
                document.getElementById("idSezioneDaModificare").value = id;
                document.getElementById("idSezione").value = idSezione;
                document.getElementById("classeSezione").value = classeSezione;
                document.getElementById("margineSezione").value = margineSezione;
                document.getElementById("paddingSezione").value = paddindSezione;

                if (typeof switchModalSezione !== 'undefined') {
                    switchModalSezione.destroy();
                    document.getElementById("contenitoreCheckboxLarghezza").innerHTML = "";

                    document.getElementById("contenitoreCheckboxLarghezza").innerHTML = "<input type=\"checkbox\" id=\"sezioneATuttaLarghezza\" name=\"sezioneATuttaLarghezza\" value=\"si\" /><label>A tutta larghezza</label>";                    
                }

                var checkboxSezioneATuttaLarghezza = document.getElementById("sezioneATuttaLarghezza");
                if(aTuttaLarghezza==='si') {    
                    checkboxSezioneATuttaLarghezza.checked   = true;
                }
                checkboxSezioneATuttaLarghezza.className = "js-switch-modal";

                var elementoSwitchModal = document.querySelector('.js-switch-modal');
                switchModalSezione  = new Switchery(elementoSwitchModal,{ size: 'small', color: 'var(--primary)', jackColor: '#FFF' });

                $('#modifica-impostazioni-sezione').modal('show');
            }

            function modificaPosizioneComponenteDaInput(idComponente) {
                var posizione = document.getElementById("posizioneComponente"+idComponente).value;
                modificaPosizioneComponente(idComponente,posizione);
            }

            function modificaPosizioneComponente(idComponente,posizione) {
                $.ajax({
                    type:"POST",
                    url:"../controller/controllerContenuti.php",
                    data:{
                        operazione:"modificaPosizioneComponente",
                        id:<?php echo $elemento["id"] ?>,
                        idComponente:idComponente,
                        posizione:posizione
                    },
                    success:function(esito) {
                        if(esito=="ok") {                
                            aggiornaComponentiPagina();
                        }
                        else {
                            alert(esito);
                        }
                    },
                    error: function(xhr,status,error) {
                        alert(status+" "+error);
                    }
                });
            }

            function duplicaComponente(idComponente) {
                $.ajax({
                    type:"POST",
                    url:"../controller/controllerContenuti.php",
                    data:{
                        operazione:"duplicaComponente",
                        id:<?php echo $elemento["id"] ?>,
                        idComponente:idComponente
                    },
                    success:function(esito) {
                        if(esito=="ok") {
                            aggiornaComponentiPagina();
                        }
                        else {
                            alert(esito);
                        }
                    },
                    error: function(xhr,status,error) {
                        alert(status+" "+error);
                    }
                });
            }

            function aggiornaComponentiPagina() {
                $.ajax({
                    type:"POST",
                    url:"../controller/controllerContenuti.php",
                    data:{
                        operazione:"stampaComponentiContenuto",
                        id:<?php echo $elemento["id"] ?>
                    },
                    success:function(codice) {
                        document.getElementById("componentiContenuto").innerHTML = codice;
                    },
                    error: function(xhr,status,error) {
                        alert(status+" "+error);
                    }
                });
            }

            function eliminaImmagineInEvidenza() {
                $.ajax({
                    type:"POST",
                    url:"controller/controllerComponente.php",
                    data:{
                        operazione:"eliminaImmagineElemento",
                        id:<?php echo $elemento["idVisualizzatoreTestimonianze"] ?>,
                        idElemento:<?php echo $elemento["id"] ?>
                    },
                    success:function(result) {
                        if(result=="ok") {
                            document.getElementById("immagineElemento").src="../../../immagini/altro/segnaposto.png";
                        }
                    },
                    error: function() {
                        alert("Si sono verificato problemi durante la richiesta, riprova tra qualche istante");
                    }
                });
            }

            function traduci(id) {
                var l =$('#linguaTraduzione').val();
                location.href="../controller/controllerContenuti.php?id="+id+"&operazione=traduci&lingua="+l;
            }

            function eliminaPagina(id,titoloPagina) {
                $('#paginaDaEliminare').val(id);
                $('#nomePaginaDaEliminare').text(titoloPagina);
                $('#modalEliminaTraduzione').modal('show');
            }

            function eseguiEliminazionePagina() {
                var id = $('#paginaDaEliminare').val();
                $.ajax({
                    type:"POST",
                    url:"../controller/controllerContenuti.php",
                    data:{
                        operazione:"elimina",
                        id:id
                    },
                    success:function(result) {
                        if(result=="ok") {
                            document.getElementById("pagina"+id).className = "d-none";
                            $('#modalEliminaTraduzione').modal('hide');
                        }
                    },
                    error: function() {
                        alert("Si sono verificato problemi durante la richiesta, riprova tra qualche istante");
                    }
                });
            }
            
            function apriPopupSelezioneImmagini() {
                $.ajax({
                    type:"POST",
                    url:"../../../controller/controllerRisorse.php",
                    data:{
                        operazione:"stampaImmaginiCartellaAltro",
                        id:<?php echo $elemento["id"] ?>,
                        immaginePartenza:0,
                        numeroImmagini:18
                    },
                    success:function(codice) {
                        document.getElementById("divSelezioneFoto").innerHTML = codice;
                        $('#modal-seleziona-foto').modal('show');
                    },
                    error: function() {
                        alert("Si sono verificato problemi durante la richiesta, riprova tra qualche istante");
                    }
                });
            }
            
            function cambiaImmagineInEvidenzaDaPopup(percorso) {
                modificaImmagineElementoComponente(<?php echo $elemento["id"] ?>,percorso);
                $('#modal-seleziona-foto').modal('hide');
            }
            
            function aggiungiImmaginiModalSelezioneImmagini(immaginePartenza,numeroImmagini) {
                $.ajax({
                    type:"POST",
                    url:"../../../controller/controllerRisorse.php",
                    data:{
                        operazione:"stampaImmaginiCartellaAltro",
                        id:<?php echo $elemento["id"] ?>,
                        immaginePartenza:immaginePartenza,
                        numeroImmagini:numeroImmagini
                    },
                    success:function(codice) {
                        var vecchioCodice = document.getElementById("divSelezioneFoto").innerHTML; 
                        document.getElementById("divSelezioneFoto").innerHTML = vecchioCodice+codice;
                        
                        // aggiorno i dati del pulsante
                        var nuovaImmagineDiPartenza = immaginePartenza+numeroImmagini;
                        document.getElementById("divBottoneModalSelezionaFoto").innerHTML = '<button type="button" class="btn btn-outline-primary" onclick="aggiungiImmaginiModalSelezioneImmagini('+nuovaImmagineDiPartenza+','+numeroImmagini+')">Mostra altre immagini</button>';
                    },
                    error: function() {
                        alert("Si sono verificato problemi durante la richiesta, riprova tra qualche istante");
                    }
                });
            }
        </script>
    </body>
</html>
